<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:31.969193710 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A77" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA77CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA77STALL_BACKEND / $BackendStalledCyclesCortexA77CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Barrier Operations Percentage">
        <series color="19,148,180" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA77INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA77ISB_SPEC + $BarrierOperationsPercentageCortexA77DSB_SPEC) + $BarrierOperationsPercentageCortexA77DMB_SPEC) / $BarrierOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Misprediction Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA77BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA77BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA77BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA77INST_RETIRED &gt; 0), (($BranchMPKICortexA77BR_MIS_PRED_RETIRED / $BranchMPKICortexA77INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA77INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA77BR_IMMED_SPEC + $BranchOperationsPercentageCortexA77BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexA77INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexA77CPU_CYCLES / $CyclesPerInstructionCortexA77INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA77INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA77CRYPTO_SPEC / $CryptoOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB MPKI">
        <series color="19,148,180" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA77INST_RETIRED &gt; 0), (($DTLBMPKICortexA77DTLB_WALK / $DTLBMPKICortexA77INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA77L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA77DTLB_WALK / $DTLBWalkPercentageCortexA77L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA77CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA77STALL_FRONTEND / $FrontendStalledCyclesCortexA77CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA77INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA77DP_SPEC - $IntegerOperationsPercentageCortexA77DSB_SPEC) / $IntegerOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA77CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA77INST_RETIRED / $InstructionsPerCycleCortexA77CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB MPKI">
        <series color="19,148,180" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA77INST_RETIRED &gt; 0), (($ITLBMPKICortexA77ITLB_WALK / $ITLBMPKICortexA77INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA77L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA77ITLB_WALK / $ITLBWalkPercentageCortexA77L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKICortexA77INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKICortexA77L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKICortexA77L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKICortexA77INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA77L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA77L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA77L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA77INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA77L1D_CACHE_REFILL / $L1DCacheMPKICortexA77INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA77L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA77L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA77L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA77INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA77L1D_TLB_REFILL / $L1DataTLBMPKICortexA77INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA77L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA77L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA77L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA77INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA77L1I_CACHE_REFILL / $L1ICacheMPKICortexA77INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA77L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA77L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA77L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA77INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA77L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA77INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA77L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA77L2D_CACHE_REFILL / $L2CacheMissPercentageCortexA77L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA77INST_RETIRED &gt; 0), (($L2CacheMPKICortexA77L2D_CACHE_REFILL / $L2CacheMPKICortexA77INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA77L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA77L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA77L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA77INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA77L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA77INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data demand accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheDemandMPKICortexA77INST_RETIRED &gt; 0), ((($L2DCacheDemandMPKICortexA77L2D_CACHE_REFILL_RD + $L2DCacheDemandMPKICortexA77L2D_CACHE_REFILL_WR) / $L2DCacheDemandMPKICortexA77INST_RETIRED) * 1000), 0)" name="L2D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageCortexA77L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageCortexA77L2D_CACHE_REFILL / $L2DCacheMissPercentageCortexA77L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKICortexA77INST_RETIRED &gt; 0), (($L2DCacheMPKICortexA77L2D_CACHE_REFILL / $L2DCacheMPKICortexA77INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA77L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexA77L3D_CACHE_REFILL / $L3CacheMissPercentageCortexA77L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA77INST_RETIRED &gt; 0), (($L3CacheMPKICortexA77L3D_CACHE_REFILL / $L3CacheMPKICortexA77INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexA77INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexA77LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexA77INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA77LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA77LL_CACHE_RD - $LLCacheReadHitPercentageCortexA77LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA77LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA77LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA77LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA77LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA77INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA77LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA77INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA77LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA77LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA77LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA77INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA77LD_SPEC / $LoadOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA77INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA77LDST_SPEC / $LoadStoreOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Acquire Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexA77INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexA77RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexA77INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Release Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexA77INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexA77RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexA77INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Instructions Percentage">
        <series color="19,148,180" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageCortexA77INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageCortexA77INST_RETIRED / $RetiredInstructionsPercentageCortexA77INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA77INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA77VFP_SPEC / $FloatingPointOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA77INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA77ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA77LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA77ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA77LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA77INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA77ST_SPEC / $StoreOperationsPercentageCortexA77INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKICortexA77INST_SPEC &gt; 0), (($StoreExclusiveFailuresPKICortexA77STREX_FAIL_SPEC / $StoreExclusiveFailuresPKICortexA77INST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Failures Percentage">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed as a percentage of store-exclusive instructions speculatively executed" expression="if(($StoreExclusiveFailuresPercentageCortexA77STREX_SPEC &gt; 0), min(($StoreExclusiveFailuresPercentageCortexA77STREX_FAIL_SPEC / $StoreExclusiveFailuresPercentageCortexA77STREX_SPEC), 1), 0)" name="Store-Exclusive Failures Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexA77INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexA77STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexA77INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv8_Cortex_A77_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A77_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_cpi" />
    <select-metric id="ARMv8_Cortex_A77_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A77_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A77_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l2d_cache_demand_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l2d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A77_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A77_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_store_percentage" />
    <select-metric id="ARMv8_Cortex_A77_metric_strex_fail_mpki" />
    <select-metric id="ARMv8_Cortex_A77_metric_strex_fail_percent" />
    <select-metric id="ARMv8_Cortex_A77_metric_strex_percentage" />
</template>
